class scrapeblock extends composition {

  int blockOriginX = (width/2) - ((width/4)/2);
  int blockOriginY = (height/2) - ((height/4)/2);
  block b;
  segment[] currentLine;
  segment[][] linesInsideBlock = new segment[0][0];
  segment[][] linesOutsideBlock = new segment[0][0];
  boolean startsInBlock;
  boolean segAppended;

  // begin by drawing lines through the square?

  scrapeblock(int origX, int origY, int sizeMod) {
    blockOriginX = origX;
    blockOriginY = origY;
    b = new block(width/sizeMod, height/sizeMod, blockOriginX, blockOriginY);
    b.draw();
  }

  void draw() {
  }

  void mouseMoved() {
  }

  void mousePress() {
    if (mouseInBlock(b)) {
      startsInBlock = true;
    }
    else { 
      startsInBlock = false;
      stroke(255);
    }
    currentLine = new segment[0];
    segAppended = false;
  }

  void mouseRelease() {
    if (!startsInBlock) {linesOutsideBlock = (segment[][]) append(linesOutsideBlock, currentLine);

    }
    else if (startsInBlock && !segAppended) {
      linesInsideBlock = (segment[][]) append(linesInsideBlock, currentLine);
      //lineLibrary = addLineToLineLibrary(currentLine, lineLibrary);
      isDrawing = false;
    }
  }

  boolean isDrawing = true;
  void mouseDrag() {

    if (isDrawing) {
      if (startsInBlock) {
        if (mouseInBlock(b)) {
          currentLine = (segment[]) append(currentLine, new segment(pmouseX - b.x, pmouseY - b.y, mouseX - b.x, mouseY - b.y));
          //if (currentLine.length > 20) {
            //currentLine = (segment[]) subset(currentLine, 1);
          //}
        }
      } 
      else {
        currentLine = (segment[]) append(currentLine, new segment(pmouseX, pmouseY, mouseX, mouseY));
        stroke(255);
        for (segment s : currentLine) {
          // line(s.x1, s.y1, s.x2, s.y2);
        }
      }
    }

    if (startsInBlock && !mouseInBlock(b)) {
      b.x += mouseX - pmouseX;
      b.y += mouseY - pmouseY;
    }
    else if (!startsInBlock && mouseInBlock(b)) {
      b.x += mouseX - pmouseX;
      b.y += mouseY - pmouseY;
    }

    //drawLinesOutsideBlock();
    b.draw();
    drawLinesInsideBlock();

    if (mouseInBlock(b)) {
      stroke(255);
      for (segment s : currentLine) {
        line(b.x + s.x1, b.y + s.y1, b.x + s.x2, b.y + s.y2);
      }
    }
  }

  void drawLinesInsideBlock() {

    stroke(255);
    //strokeCap(SQUARE);

    for (segment[] lines : linesInsideBlock) {
      for (segment seg : lines) {
        line(b.x+ seg.x1, b.y + seg.y1, b.x + seg.x2, b.y + seg.y2);
      }
    }
  }

  void drawLinesOutsideBlock() {

    stroke(255);
    strokeCap(SQUARE);

    for (segment[] lines : linesOutsideBlock) {
      for (segment seg : lines) {
        line(seg.x1, seg.y1, seg.x2, seg.y2);
      }
    }
  }

  boolean mouseInBlock(block blockToCheck) {
    if (mouseX >= b.x && mouseX <= (b.x + b.w)) {
      if (mouseY >= b.y && mouseY <= (b.y+ b.h)) {
        return true;
      }
    }
    return false;
  }
}

class block {

  int w;
  int h;
  int x;
  int y;

  block(int blockWidth, int blockHeight, int xPos, int yPos) {
    w = blockWidth;
    h = blockHeight;
    x = xPos;
    y = yPos;
  }

  void draw() {
    noStroke();
    //stroke(255,0,0);
    //fill(255);
    rect(x, y, w, h);
  }
}

